<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>DATA RUMA TANGGA</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">DATA RUMAH TANGGA</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content centered">
        <div class="container-fluid ">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Anggota Rumah Tangga</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="table-kk2" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="text-center">
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>Nomor KK</th>
                                        <th>NIK</th>
                                        <th>Hubungan Keluarga</th>
                                        <th>Umur</th>
                                        <th>Penyakit</th>
                                        <th>Partisipasi Sekolah</th>
                                        <th>Bekerja</th>
                                        <th>Lapangan Usaha</th>
                                        <th>Kepemilikan Kartu</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1 ?>
                                    <?php foreach ($agt as $u) {
                                    ?>
                                        <tr>
                                            <td><?= $no++ ?></td>
                                            <td><?= $u->nama ?></td>
                                            <td><?= $u->nokk ?></td>
                                            <td><?= $u->nik ?></td>
                                            <?php if ($u->hubkel == 1) : ?>
                                                <td>Kepala Keluarga</td>
                                            <?php elseif ($u->hubkel == 2) : ?>
                                                <td>Istri/Suami</td>
                                            <?php elseif ($u->hubkel == 3) : ?>
                                                <td>Anak</td>
                                            <?php elseif ($u->hubkel == 4) : ?>
                                                <td>Menantu</td>
                                            <?php elseif ($u->hubkel == 5) : ?>
                                                <td>Cucu</td>
                                            <?php elseif ($u->hubkel == 6) : ?>
                                                <td>Orang Tua</td>
                                            <?php elseif ($u->hubkel == 7) : ?>
                                                <td>Pembantu</td>
                                            <?php elseif ($u->hubkel == 8) : ?>
                                                <td>Lainnya</td>
                                            <?php else : ?>
                                                <td>Belum Terisi</td>
                                            <?php endif ?>
                                            <td><?= $u->umur ?></td>
                                           <?php
$penyakitList = [];

if (!isset($u->kronis) || $u->kronis === '' || $u->kronis === null) {
    $hasil = 'Belum Terisi';
} elseif ($u->kronis == 0) {
    $hasil = 'Tidak ada';
} else {
    if ($u->kronis & 1)   $penyakitList[] = 'Rematik';
    if ($u->kronis & 2)   $penyakitList[] = 'Asma';
    if ($u->kronis & 4)   $penyakitList[] = 'Masalah Jantung';
    if ($u->kronis & 8)   $penyakitList[] = 'Diabetes';
    if ($u->kronis & 16)  $penyakitList[] = 'TBC';
    if ($u->kronis & 32)  $penyakitList[] = 'Stroke';
    if ($u->kronis & 64)  $penyakitList[] = 'Kanker';
    if ($u->kronis & 128) $penyakitList[] = 'Gagal Ginjal';
    if ($u->kronis & 256) $penyakitList[] = 'Pikun';
    if ($u->kronis & 512) $penyakitList[] = 'Lainnya';

    $hasil = implode(', ', $penyakitList);
}
?>

<td><?= htmlspecialchars($hasil, ENT_QUOTES, 'UTF-8') ?></td>

                                            <?php if ($u->sekolah == 2) : ?>
                                                <td>Masih Sekolah</td>
                                            <?php elseif ($u->sekolah == 3) : ?>
                                                <td>Tidak Bersekolah</td>
                                            <?php elseif ($u->sekolah == 1) : ?>
                                                <td>Tidak / Belum Bersekolah</td>
                                            <?php else : ?>
                                                <td>Belum Terisi</td>
                                            <?php endif ?>
                                            <?php if ($u->kerja == 1) : ?>
                                                <td>Ya</td>
                                            <?php elseif ($u->kerja == 2) : ?>
                                                <td>Tidak</td>
                                            <?php else : ?>
                                                <td>Belum Terisi</td>
                                            <?php endif ?>
                                           <?php if ($u->lapangan == 1): ?>
    <td>Pertanian</td>
<?php elseif ($u->lapangan == 2): ?>
    <td>Hortikultura</td>
<?php elseif ($u->lapangan == 3): ?>
    <td>Perkebunan</td>
<?php elseif ($u->lapangan == 4): ?>
    <td>Perikanan</td>
<?php elseif ($u->lapangan == 5): ?>
    <td>Peternakan</td>
<?php elseif ($u->lapangan == 6): ?>
    <td>Kehutanan & Pertanian lainnya</td>
<?php elseif ($u->lapangan == 7): ?>
    <td>Pertambangan / Penggalian</td>
<?php elseif ($u->lapangan == 8): ?>
    <td>Industri Pengolahan</td>
<?php elseif ($u->lapangan == 9): ?>
    <td>Pengadaan listrik, gas, uap/air panas, dan udara dingin</td>
<?php elseif ($u->lapangan == 10): ?>
    <td>Pengelolaan air, air limbah, daur ulang sampah, dan aktivitas remediasi</td>
<?php elseif ($u->lapangan == 11): ?>
    <td>Konstruksi</td>
<?php elseif ($u->lapangan == 12): ?>
    <td>Perdagangan besar dan eceran, reparasi dan perawatan mobil dan sepeda motor</td>
<?php elseif ($u->lapangan == 13): ?>
    <td>Pengangkutan dan pergudangan</td>
<?php elseif ($u->lapangan == 14): ?>
    <td>Penyediaan akomodasi & makan minum</td>
<?php elseif ($u->lapangan == 15): ?>
    <td>Informasi & komunikasi</td>
<?php elseif ($u->lapangan == 16): ?>
    <td>Keuangan & asuransi</td>
<?php elseif ($u->lapangan == 17): ?>
    <td>Real Estate</td>
<?php elseif ($u->lapangan == 18): ?>
    <td>Aktivitas profesional, ilmiah dan teknis</td>
<?php elseif ($u->lapangan == 19): ?>
    <td>Aktivitas penyewaan dan sewa guna tanpa hak opsi, ketenagakerjaan, agen perjalanan dan penunjang usaha lainnya</td>
<?php elseif ($u->lapangan == 20): ?>
    <td>Administrasi pemerintahan, pertahanan, dan jaminan sosial wajib</td>
<?php elseif ($u->lapangan == 21): ?>
    <td>Pendidikan</td>
<?php elseif ($u->lapangan == 22): ?>
    <td>Aktivitas kesehatan manusia dan aktivitas sosial</td>
<?php elseif ($u->lapangan == 23): ?>
    <td>Kesenian, hiburan, dan rekreasi</td>
<?php elseif ($u->lapangan == 24): ?>
    <td>Aktivitas jasa lainnya</td>
<?php elseif ($u->lapangan == 25): ?>
    <td>Aktivitas keluarga sebagai pemberi kerja</td>
<?php elseif ($u->lapangan == 26): ?>
    <td>Aktivitas badan internasional dan badan ekstra internasional lainnya</td>
<?php else: ?>
    <td>Belum Terisi</td>
<?php endif; ?>

                                            <?php
$kartuList = [
    '0' => 'Tidak memiliki',
    '1' => 'BPJS Kesehatan Gratis',
    '2' => 'BPJS Kesehatan Mandiri',
    '4' => 'KIP',
    '8' => 'BPJS Ketenagakerjaan'
];

$bansosRaw = $u->ki; // contoh: "1,2,4"
if (!empty($bansosRaw)) {
    $kartuIds = explode(',', $bansosRaw);
    $kartuLabels = [];

    foreach ($kartuIds as $id) {
        $id = trim($id);
        if (array_key_exists($id, $kartuList)) {
            $kartuLabels[] = $kartuList[$id];
        }
    }

    if (!empty($kartuLabels)) {
        echo '<td>' . implode(', ', $kartuLabels) . '</td>';
    } else {
        echo '<td>Belum Terisi</td>';
    }
} else {
    echo '<td>Belum Terisi</td>';
}
?>

                                            <td><a class="btn btn-info ubahkegiatan btn-sm mb-2" href="<?= base_url(''); ?>kelola_ruta_agt/ubahart/<?= $u->id_agt ?>/<?= $u->id_pm_agt ?>">
                                                    <i class="fas fa-pencil-alt">
                                                    </i>
                                                    Ubah data
                                                </a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <!-- <tfoot>
                                    <tr>
                                        <th>Rendering engine</th>
                                        <th>Browser</th>
                                        <th>Platform(s)</th>
                                        <th>Engine version</th>
                                        <th>CSS grade</th>
                                    </tr>
                                </tfoot> -->
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>

                </div>

            </div>

            <!-- <div class="row">
                <div class="col-12 mb-2">
                    <a href="<?= base_url() ?>" class="btn btn-secondary">Cancel</a>
                    <a href="<?= base_url() ?>tambah_ruta/lanjutan" class="btn btn-success float-right">Selanjutnnya</a>
                </div>
            </div> -->
        </div><!-- /.container-fluid -->
    </section>

    <!-- /.content -->
</div>
<?php
if (isset($_SESSION['informasi'])) {
    echo $_SESSION['informasi'];
    unset($_SESSION['informasi']);
}
?>
<?php
if (isset($_SESSION['error'])) {
    echo $_SESSION['error'];
    unset($_SESSION['error']);
}
?>