
<?php

defined('BASEPATH') or exit('No direct script access allowed');
/**
 * @property CI_Form_validation $form_validation
 * @property CI_Session $session
 * @property CI_Input $input
 * @property CI_DB $db
 */
class login extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        setlocale(LC_ALL, 'id_ID.utf8');
        $this->load->library('form_validation');
        $this->load->model('Tambah_ruta_model', 'ruta', true);

        // $this->load->model('user_model', '', true);

        // is_login();
        // is_admin();
    }
    public function index()
    {
        // $data['agt'] = $this->ruta->getagt();
        // var_dump($data['ruta']);
        $this->form_validation->set_rules('email', 'Email', 'trim|required', [
            'required' => "Email wajib diisi",
        ]);
        $this->form_validation->set_rules('password', 'Kata Sandi', 'trim|required', [
            'required' => "Kata Sandi wajib diisi",
        ]);
        if ($this->form_validation->run() == false) {
            $data['title'] = 'PENGOLAHAN DESA CANTIK ~ DESA SROYO';
            $this->load->view('login');
        } else {
            $this->_login();
        }
    }
    private function _login()
    {
        $email = $this->input->post('email');
        $pass = $this->input->post('password');

        $user = $this->db->get_where('dc_pengguna', ['email' => $email])->row_array();
        // var_dump($user);
        if ($user) {
            if (password_verify($pass, $user['password'])) {
                $data = [
                    'email' => $user['email'],
                ];
                $this->session->set_userdata($data);
                redirect('tambah_ruta');
            } else {
                $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Kata Sandi Salah','error');</script>");
                redirect('login');
            }
        } else {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Email Tidak Terdaftar','error');</script>");
            redirect('login');
        }
    }
    public function logout()
    {
        $this->session->unset_userdata('email');
        // $this->session->unset_userdata('id_role');


        $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Logout','success');</script>");
        redirect('login');
    }
}
